/**
 * \file: arch_session.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * \component: Secure Data Container
 * \brief : sdc_arch_session and related structs / defines / types
 *
 * <b>SDC private header</b>
 *
 * \authors: Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2017 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#ifndef IMX6_ARCH_STRUCT_DEF_H_
#define IMX6_ARCH_STRUCT_DEF_H_

/* Max block lengths of operations */
#define CAAM_EE_MAX_ENC_BLOCK_ALIGN 16
#define CAAM_EE_MAX_SIGN_BLOCK_ALIGN 64
#define CAAM_EE_MAX_DGST_BLOCK_ALIGN 64

/**
 * \brief Max unaligned length of IMX6
 *
 * This length is used in architecture independent code to determine
 * the size of the buffer to handle alignment.
 * The value equals the max block length of all operations needing
 * to be aligned.
 *
 * This is the max unaligned length of CAAM_EE_MAX_ENC_BLOCK_ALIGN,
 * CAAM_EE_MAX_SIGN_BLOCK_ALIGN, CAAM_EE_MAX_DGST_BLOCK_ALIGN.
 */
#define SDC_ARCH_MAX_UNALIGNED_LEN 64

/* Max IV length */
#define CAAM_EE_MAX_IV_LEN CAAM_EE_MAX_ENC_BLOCK_ALIGN

/**
 * \brief IMX6 specific session content
 */
struct sdc_arch_session {
    int fd;
    unsigned long int request;
    uint8_t iv[CAAM_EE_MAX_IV_LEN];
    size_t iv_len;
    size_t buf_idx;
};

#endif
